/*
 * Decompiled with CFR 0.152.
 */
package jclass.table3;

import java.awt.Component;
import java.io.Serializable;
import java.util.Vector;
import jclass.table3.Chain;
import jclass.table3.JCCellRange;
import jclass.table3.JCDisplayComponentEvent;
import jclass.table3.Layout;
import jclass.table3.Series;
import jclass.table3.SeriesUtil;
import jclass.table3.SeriesValue;
import jclass.table3.Shift;
import jclass.table3.Size;
import jclass.table3.Table;
import jclass.table3.WidgetSeriesValue;

class TableDataUtil {
    static void addColumn(Table table, int n, int n2, int n3, int n4) {
        if (n < n4 - n2) {
            Shift.columnSeries(table, n, n2, 3);
        }
        if (table.getPeer() == null) {
            return;
        }
        if (!table.repaint) {
            table.needs_recalc = true;
            return;
        }
        Size.setDimensions(table, 3, n3, n4 - 1, -998, 0, n, 1, true);
        TableDataUtil.resize_table(table);
        if (table.isShowing()) {
            table.repaint();
        }
        TableDataUtil.redisplayComponents(table);
    }

    static void addRow(Table table, int n, int n2, int n3, int n4) {
        if (n < n3 - n2) {
            Shift.rowSeries(table, n, n2, 4);
        }
        if (table.getPeer() == null) {
            return;
        }
        if (!table.repaint) {
            table.needs_recalc = true;
            return;
        }
        Size.setDimensions(table, 4, n3 - 1, n4, n, n2, -998, 0, true);
        TableDataUtil.resize_table(table);
        TableDataUtil.redisplayComponents(table);
    }

    static void deleteColumns(Table table, int n, int n2, int n3, int n4) {
        Shift.columnSeries(table, n, n2, 1);
        if (table.getPeer() == null) {
            return;
        }
        if (!table.repaint) {
            table.needs_recalc = true;
            return;
        }
        Size.setDimensions(table, 1, n3, n4 + n2, -998, 0, n, n2, true);
        if (table.left_column >= n4) {
            table.clip.horiz_origin = 0;
            table.left_column = 0;
        }
        TableDataUtil.resize_table(table);
        TableDataUtil.redisplayComponents(table);
    }

    static void deleteRow(Table table, int n, int n2, int n3, int n4) {
        Shift.rowSeries(table, n, n2, 2);
        if (table.getPeer() == null) {
            return;
        }
        if (!table.repaint) {
            table.needs_recalc = true;
            return;
        }
        Size.setDimensions(table, 2, n3 + n2, n4, n, n2, -998, 0, true);
        if (table.top_row >= n3) {
            table.clip.vert_origin = 0;
            table.top_row = 0;
        }
        TableDataUtil.resize_table(table);
        TableDataUtil.redisplayComponents(table);
    }

    static boolean moveColumns(Table table, int n, int n2, int n3) {
        if (!TableDataUtil.validateMoveColumns(table, n, n2, n3)) {
            return false;
        }
        if (n + n2 == n3) {
            return true;
        }
        TableDataUtil.moveColumnSeries(table, n, n2, n3);
        table.column_widths.move(n, n2, n3);
        TableDataUtil.resize_table(table);
        if (table.isVisible()) {
            table.repaint();
        }
        TableDataUtil.redisplayComponents(table);
        return true;
    }

    static boolean dragColumn(Table table, int n, int n2) {
        return TableDataUtil.moveColumns(table, n, 1, n2);
    }

    static boolean moveRows(Table table, int n, int n2, int n3) {
        if (!TableDataUtil.validateMoveRows(table, n, n2, n3)) {
            return false;
        }
        if (n + n2 == n3) {
            return true;
        }
        TableDataUtil.moveRowSeries(table, n, n2, n3);
        table.row_heights.move(n, n2, n3);
        TableDataUtil.resize_table(table);
        if (table.isShowing()) {
            table.repaint();
        }
        TableDataUtil.redisplayComponents(table);
        return true;
    }

    static boolean dragRow(Table table, int n, int n2) {
        return TableDataUtil.moveRows(table, n, 1, n2);
    }

    static void moveColumnSeries(Table table, int n, int n2, int n3) {
        int n4 = 0;
        while (n4 < table.series_list.size()) {
            Series series = (Series)table.series_list.elementAt(n4);
            SeriesUtil.moveColumns(series, n, n2, n3);
            ++n4;
        }
        TableDataUtil.selectColumns(table, n, n2, n3);
        TableDataUtil.spanColumns(table, n, n2, n3);
    }

    static void moveRowSeries(Table table, int n, int n2, int n3) {
        int n4 = 0;
        while (n4 < table.series_list.size()) {
            Series series = (Series)table.series_list.elementAt(n4);
            SeriesUtil.moveRows(series, n, n2, n3);
            ++n4;
        }
        TableDataUtil.selectRows(table, n, n2, n3);
        TableDataUtil.spanRows(table, n, n2, n3);
    }

    static void selectColumns(Table table, int n, int n2, int n3) {
        if (table.selected_cells.size() == 0) {
            return;
        }
        int n4 = table.selected_cells.size() - 1;
        while (n4 >= 0) {
            JCCellRange jCCellRange = (JCCellRange)table.selected_cells.elementAt(n4);
            if (jCCellRange.end_column != Integer.MAX_VALUE) {
                int n5 = Math.min(jCCellRange.start_column, jCCellRange.end_column);
                int n6 = Math.max(jCCellRange.start_column, jCCellRange.end_column);
                if (n6 >= n && n5 <= n + n2 - 1 || n5 < n3 && n3 <= n6) {
                    table.selected_cells.removeElementAt(n4);
                } else {
                    jCCellRange.start_column = TableDataUtil.adjustPosition(jCCellRange.start_column, n, n2, n3);
                    jCCellRange.end_column = TableDataUtil.adjustPosition(jCCellRange.end_column, n, n2, n3);
                }
            }
            --n4;
        }
    }

    static void selectRows(Table table, int n, int n2, int n3) {
        if (table.selected_cells.size() == 0) {
            return;
        }
        int n4 = table.selected_cells.size() - 1;
        while (n4 >= 0) {
            JCCellRange jCCellRange = (JCCellRange)table.selected_cells.elementAt(n4);
            if (jCCellRange.end_row != Integer.MAX_VALUE) {
                int n5 = Math.min(jCCellRange.start_row, jCCellRange.end_row);
                int n6 = Math.max(jCCellRange.start_row, jCCellRange.end_row);
                if (n6 >= n && n5 <= n + n2 - 1 || n5 < n3 && n3 <= n6) {
                    table.selected_cells.removeElementAt(n4);
                } else {
                    jCCellRange.start_row = TableDataUtil.adjustPosition(jCCellRange.start_row, n, n2, n3);
                    jCCellRange.end_row = TableDataUtil.adjustPosition(jCCellRange.end_row, n, n2, n3);
                }
            }
            --n4;
        }
    }

    static void spanColumns(Table table, int n, int n2, int n3) {
        if (table.span.span_list_orig == null || table.span.span_list_orig.size() == 0) {
            return;
        }
        int n4 = 0;
        while (n4 < table.span.span_list_orig.size()) {
            JCCellRange jCCellRange = (JCCellRange)table.span.span_list_orig.elementAt(n4);
            int n5 = jCCellRange.start_column;
            int n6 = jCCellRange.end_column;
            if (n5 != -998 && n5 != -997 && n6 != -998 && n6 != -997 && n6 != Integer.MAX_VALUE) {
                jCCellRange.start_column = TableDataUtil.adjustPosition(jCCellRange.start_column, n, n2, n3);
                jCCellRange.end_column = jCCellRange.start_column + n6 - n5;
            }
            ++n4;
        }
    }

    static void spanRows(Table table, int n, int n2, int n3) {
        if (table.span.span_list_orig == null || table.span.span_list_orig.size() == 0) {
            return;
        }
        int n4 = 0;
        while (n4 < table.span.span_list_orig.size()) {
            JCCellRange jCCellRange = (JCCellRange)table.span.span_list_orig.elementAt(n4);
            int n5 = jCCellRange.start_row;
            int n6 = jCCellRange.end_row;
            if (n5 != -998 && n5 != -997 && n6 != -998 && n6 != -997 && n6 != Integer.MAX_VALUE) {
                jCCellRange.start_row = TableDataUtil.adjustPosition(jCCellRange.start_row, n, n2, n3);
                jCCellRange.end_row = jCCellRange.start_row + n6 - n5;
            }
            ++n4;
        }
    }

    static boolean swapColumns(Table table, int n, int n2) {
        TableDataUtil.swapColumnSeries(table, n, n2);
        int n3 = table.column_widths.getValue(n);
        int n4 = table.column_widths.getValue(n2);
        table.column_widths.setValue(n, n, n4);
        table.column_widths.setValue(n2, n2, n3);
        TableDataUtil.resize_table(table);
        if (table.isVisible()) {
            table.repaint();
        }
        TableDataUtil.redisplayComponents(table);
        return true;
    }

    static void swapColumnSeries(Table table, int n, int n2) {
        int n3 = 0;
        while (n3 < table.series_list.size()) {
            Series series = (Series)table.series_list.elementAt(n3);
            SeriesUtil.swapColumns(series, n, n2);
            ++n3;
        }
        if (table.selected_cells.size() != 0) {
            table.selected_cells.removeAllElements();
        }
        TableDataUtil.spanColumns(table, n, 1, n2);
    }

    static boolean swapRows(Table table, int n, int n2) {
        TableDataUtil.swapRowSeries(table, n, n2);
        int n3 = table.row_heights.getValue(n);
        int n4 = table.row_heights.getValue(n2);
        table.row_heights.setValue(n, n, n4);
        table.row_heights.setValue(n2, n2, n3);
        TableDataUtil.resize_table(table);
        if (table.isVisible()) {
            table.repaint();
        }
        TableDataUtil.redisplayComponents(table);
        return true;
    }

    static void swapRowSeries(Table table, int n, int n2) {
        int n3 = 0;
        while (n3 < table.series_list.size()) {
            Series series = (Series)table.series_list.elementAt(n3);
            SeriesUtil.swapRows(series, n, n2);
            ++n3;
        }
        if (table.selected_cells.size() != 0) {
            table.selected_cells.removeAllElements();
        }
        TableDataUtil.spanRows(table, n, 1, n2);
    }

    static boolean swapRowArrays(Table table, int[] nArray, int[] nArray2) {
        Serializable serializable;
        int[] nArray3 = new int[nArray2.length];
        int[] nArray4 = new int[nArray2.length];
        int[] nArray5 = new int[nArray2.length];
        int n = 0;
        while (n < nArray2.length) {
            nArray4[nArray[n]] = n;
            ++n;
        }
        int n2 = 0;
        while (n2 < nArray2.length) {
            nArray3[nArray2[n2]] = n2;
            ++n2;
        }
        int n3 = 0;
        while (n3 < nArray2.length) {
            nArray5[n3] = nArray3[nArray[n3]];
            ++n3;
        }
        int n4 = 0;
        while (n4 < table.series_list.size()) {
            serializable = (Series)table.series_list.elementAt(n4);
            SeriesUtil.reorderRows((Series)serializable, nArray5);
            ++n4;
        }
        serializable = new Chain();
        int n5 = 0;
        while (n5 < table.rows) {
            if (n5 < nArray2.length) {
                ((Chain)serializable).appendNocalc(table.rowHeight(nArray4[nArray2[n5]]));
            } else {
                ((Chain)serializable).appendNocalc(table.rowHeight(n5));
            }
            ++n5;
        }
        ((Chain)serializable).calcPositions(0);
        table.row_heights = serializable;
        if (table.selected_cells.size() != 0) {
            if (table.mode == 1 && table.selection_policy == 3) {
                Vector<JCCellRange> vector = new Vector<JCCellRange>();
                int n6 = 0;
                while (n6 < table.selected_cells.size()) {
                    JCCellRange jCCellRange = (JCCellRange)table.selected_cells.elementAt(n6);
                    int n7 = Math.min(jCCellRange.start_row, jCCellRange.end_row);
                    int n8 = Math.max(jCCellRange.start_row, jCCellRange.end_row);
                    if (n8 == Integer.MAX_VALUE) {
                        n8 = table.getNumRows() - 1;
                    }
                    int n9 = n7;
                    while (n9 <= n8) {
                        if (nArray.length > n9 && nArray3.length > nArray[n9]) {
                            vector.addElement(new JCCellRange(nArray3[nArray[n9]], jCCellRange.start_column, nArray3[nArray[n9]], jCCellRange.end_column));
                        }
                        ++n9;
                    }
                    ++n6;
                }
                table.setSelectedCells(vector);
            } else {
                table.selected_cells.removeAllElements();
            }
        }
        return true;
    }

    static boolean swapColumnArrays(Table table, int[] nArray, int[] nArray2) {
        Serializable serializable;
        int[] nArray3 = new int[nArray2.length];
        int[] nArray4 = new int[nArray2.length];
        int[] nArray5 = new int[nArray2.length];
        int n = 0;
        while (n < nArray2.length) {
            nArray4[nArray[n]] = n;
            ++n;
        }
        int n2 = 0;
        while (n2 < nArray2.length) {
            nArray3[nArray2[n2]] = n2;
            ++n2;
        }
        int n3 = 0;
        while (n3 < nArray2.length) {
            nArray5[n3] = nArray3[nArray[n3]];
            ++n3;
        }
        int n4 = 0;
        while (n4 < table.series_list.size()) {
            serializable = (Series)table.series_list.elementAt(n4);
            SeriesUtil.reorderColumns((Series)serializable, nArray5);
            ++n4;
        }
        serializable = new Chain();
        int n5 = 0;
        while (n5 < table.columns) {
            if (n5 < nArray2.length) {
                ((Chain)serializable).appendNocalc(table.columnWidth(nArray4[nArray2[n5]]));
            } else {
                ((Chain)serializable).appendNocalc(table.columnWidth(n5));
            }
            ++n5;
        }
        ((Chain)serializable).calcPositions(0);
        table.column_widths = serializable;
        if (table.selected_cells.size() != 0) {
            if (table.mode == 1 && table.selection_policy == 3) {
                Vector<JCCellRange> vector = new Vector<JCCellRange>();
                int n6 = 0;
                while (n6 < table.selected_cells.size()) {
                    JCCellRange jCCellRange = (JCCellRange)table.selected_cells.elementAt(n6);
                    int n7 = Math.min(jCCellRange.start_column, jCCellRange.end_column);
                    int n8 = Math.max(jCCellRange.start_column, jCCellRange.end_column);
                    if (n8 == Integer.MAX_VALUE) {
                        n8 = table.getNumColumns() - 1;
                    }
                    int n9 = n7;
                    while (n9 <= n8) {
                        vector.addElement(new JCCellRange(jCCellRange.start_row, nArray3[nArray[n9]], jCCellRange.end_row, nArray3[nArray[n9]]));
                        ++n9;
                    }
                    ++n6;
                }
                table.setSelectedCells(vector);
            } else {
                table.selected_cells.removeAllElements();
            }
        }
        TableDataUtil.resize_table(table);
        if (table.isVisible()) {
            table.repaint();
        }
        TableDataUtil.redisplayComponents(table);
        return true;
    }

    static boolean validateMoveColumns(Table table, int n, int n2, int n3) {
        if (n2 <= 0) {
            return false;
        }
        if (n < 0 || n + n2 > table.columns) {
            return false;
        }
        if (n3 < 0 || n3 > table.columns || n <= n3 && n3 < n + n2) {
            return false;
        }
        return n2 < table.columns - table.frozen_columns;
    }

    static boolean validateMoveRows(Table table, int n, int n2, int n3) {
        if (n2 <= 0) {
            return false;
        }
        if (n < 0 || n + n2 > table.rows) {
            return false;
        }
        if (n3 < 0 || n3 > table.rows || n <= n3 && n3 < n + n2) {
            return false;
        }
        return n2 < table.rows - table.frozen_rows;
    }

    static int adjustPosition(int n, int n2, int n3, int n4) {
        if (n2 > n4) {
            if (n >= n4 && n < n2) {
                n += n3;
            } else if (n >= n2 && n < n2 + n3) {
                n -= n2 - n4;
            }
        } else if (n >= n2 + n3 && n < n4) {
            n -= n3;
        } else if (n >= n2 && n < n2 + n3) {
            n += n4 - n2 - n3;
        }
        return n;
    }

    private static void displayComponent(Table table, Component component, int n, int n2) {
        if (!Table.isCell(n, n2) && !Table.isLabel(n, n2) || !component.isShowing()) {
            return;
        }
        JCDisplayComponentEvent jCDisplayComponentEvent = new JCDisplayComponentEvent(table, n, n2, component);
        table.fireJCDisplayComponentEvent(jCDisplayComponentEvent);
        table.paint(n, n2);
    }

    static void redisplayComponents(Table table) {
        Series series = table.component_series;
        int n = 0;
        while (n < series.size()) {
            WidgetSeriesValue widgetSeriesValue = (WidgetSeriesValue)series.getValue(n);
            if (widgetSeriesValue != null) {
                int n2 = ((SeriesValue)series.elementAt((int)n)).row;
                int n3 = ((SeriesValue)series.elementAt((int)n)).column;
                TableDataUtil.displayComponent(table, widgetSeriesValue.component, n2, n3);
                int n4 = 0;
                while (n4 < widgetSeriesValue.clones.length) {
                    TableDataUtil.displayComponent(table, widgetSeriesValue.clones[n4], widgetSeriesValue.row[n4], widgetSeriesValue.column[n4]);
                    ++n4;
                }
            }
            ++n;
        }
    }

    static void resize_table(Table table) {
        Layout.doLayout(table);
        if (table.span.doSpansExist()) {
            table.span.copy();
        }
    }

    TableDataUtil() {
    }
}

